/*
 * Decompiled with CFR 0.152.
 */
package dev.upcraft.datasync.content;

import com.google.gson.JsonElement;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.upcraft.datasync.DataSyncMod;
import dev.upcraft.datasync.api.SyncToken;
import dev.upcraft.datasync.api.util.GameProfileHelper;
import dev.upcraft.datasync.client.DataSyncModClient;
import dev.upcraft.datasync.client.Session;
import dev.upcraft.datasync.content.DataStore;
import dev.upcraft.datasync.content.StoredDataHolder;
import dev.upcraft.datasync.net.C2SUpdatePlayerDataPacket;
import dev.upcraft.datasync.web.HttpUtil;
import java.net.URI;
import java.net.http.HttpRequest;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

public record DataType<T>(Class<T> type, class_2960 id, Codec<T> codec) implements SyncToken<T>
{
    @Override
    public CompletableFuture<Optional<T>> fetch(UUID playerId) {
        return DataStore.lookup(playerId, this, false).asFuture();
    }

    @Override
    public Optional<T> getCached(UUID playerId) {
        return DataStore.getCached(playerId, this);
    }

    @Override
    public CompletableFuture<Void> setData(@Nullable T data) {
        if (FabricLoader.getInstance().getEnvironmentType() != EnvType.CLIENT) {
            throw new UnsupportedOperationException("Attempted to set player data for %s on a server".formatted(this.id()));
        }
        GameProfile profile = GameProfileHelper.getClientProfile();
        UUID playerId = profile.getId();
        StoredDataHolder<T> lookup = DataStore.getPlayerLookupEmpty(playerId, this);
        @Nullable T previous = lookup.value();
        lookup.setValue(data);
        if (GameProfileHelper.isOfflineProfile(profile)) {
            DataSyncMod.LOGGER.debug("Client is using offline mode, cannot persist data!");
            return CompletableFuture.completedFuture(null);
        }
        DataSyncMod.LOGGER.debug("Sending update for {}", (Object)this.id());
        JsonElement json = (JsonElement)this.codec().encodeStart((DynamicOps)JsonOps.INSTANCE, data).resultOrPartial(errMsg -> DataSyncMod.LOGGER.error("Unable to encode data update for {}: {}", (Object)this.id(), errMsg)).orElseThrow();
        URI uri = URI.create(String.format("%s/v0/data/%s/%s", "https://datasync-api.uuid.gg/api", playerId, HttpUtil.urlEncode(this.id())));
        return ((CompletableFuture)CompletableFuture.runAsync(() -> HttpUtil.postJsonRequest(uri, json, builder -> {
            Session session = DataSyncModClient.SESSION_STORE.getSession();
            if (session == null || !session.isValid()) {
                Either<Session, String> loginAttempt = DataSyncModClient.SESSION_STORE.login();
                if (loginAttempt.right().isPresent()) {
                    throw new RuntimeException("Unable to log in: " + (String)loginAttempt.right().orElseThrow());
                }
                session = (Session)loginAttempt.orThrow();
            }
            return builder.header("Authorization", "Bearer %s".formatted(session.accessToken()));
        })).thenRunAsync(() -> C2SUpdatePlayerDataPacket.trySend(this.id()), (Executor)class_310.method_1551())).exceptionally(t -> {
            DataSyncMod.LOGGER.error("Unable to send data update for {}, restoring previous state", (Object)this.id(), t);
            lookup.setValue(previous);
            return null;
        });
    }

    @Nullable
    public T fetchRemote(UUID playerId) {
        if (!DataSyncMod.HAS_INTERNET) {
            return null;
        }
        URI uri = URI.create(String.format("%s/v0/data/%s/%s", "https://datasync-api.uuid.gg/api", playerId, HttpUtil.urlEncode(this.id())));
        HttpRequest.Builder request = HttpRequest.newBuilder(uri);
        JsonElement json = HttpUtil.makeJsonRequest(request);
        if (json == null) {
            return null;
        }
        return this.codec().decode((DynamicOps)JsonOps.INSTANCE, (Object)json).resultOrPartial(errMsg -> DataSyncMod.LOGGER.error("Unable to decode response from {}: {}", (Object)uri, errMsg)).map(Pair::getFirst).orElse(null);
    }

    @Override
    public Optional<T> get(UUID playerId) {
        return Optional.ofNullable(DataStore.lookup(playerId, this, false).value());
    }

    @Override
    public T getOrDefault(UUID playerId, T defaultValue) {
        return DataStore.lookup(playerId, this, false).or(defaultValue);
    }
}

